/*
 * TagReadBeep.cpp
 *
 *  Created on: 27.04.2010
 *      Author: stefan.detter
 */

#include "TagReadBeep.h"

#include "../../../Settings.h"
#include "../../../sound/SoundManager.h"


TagReadBeep::TagReadBeep(QWidget* mainWidget, Application* app, QObject* parent)
	: TagReadHandlerBase(mainWidget, app, parent)
{
	connect(Settings::d, 			SIGNAL(readBeepChanged(bool)),
			this, 					  SLOT(handlingActivated(bool)));

	handlingActivated(Settings::d->readBeepOn());
}

TagReadBeep::~TagReadBeep() 
{
} 

void TagReadBeep::handlingActivated ( bool on )
{
	m_beepType 		= Settings::d->readBeepType();
	m_beepParallel	= Settings::d->readBeepParallel();
	TagReadHandlerBase::handlingActivated(on);
}

void TagReadBeep::tagEvent(const TagEvent& /*event*/)
{
	if(!m_handlingOn)
		return;

	SoundManager::d->setParallelCount(m_beepParallel);
	SoundManager::d->playSound(m_beepType);
}



